const auctionsBoxList = document.getElementById('auctions-box-list')

function updateAuctions (auctionsArray = []) {
  auctionsBoxList.innerHTML = ''
  for (const { name, lore } of auctionsArray) {
    const el = document.createElement('li')
    const newName = replaceColorCodes(name)
    const newLore = replaceColorCodes(lore)
    el.append(newName)
    el.append(newLore)
    el.classList.add('auction-item')
    auctionsBoxList.appendChild(el)
  }
}

socket.on('auctionsData', (data) => {
  console.log(`Received ${data.length} auctions`)
  updateAuctions(data)
})
