function msToTime(seconds) {
    const ms = seconds % 1000
    seconds = (seconds - ms) / 1000
    const secs = seconds % 60
    seconds = (seconds - secs) / 60
    const mins = seconds % 60
    const hrs = (seconds - mins) / 60

    return pad(hrs) + ':' + pad(mins) + ':' + pad(secs)
}

function pad(n, z) {
    z = z || 2
    return ('00' + n).slice(-z)
}

function getWindowSlotsCoords() {

    const windowSlotsCoords = {
        inventory: {},
    }

    windowSlotsCoords.inventory = {
        // Crafting slots
        0: [307, 55],
        1: [195, 35],
        2: [231, 35],
        3: [195, 71],
        4: [231, 71],

        5: [15, 15], // Helmet
        9: [15, 167], // Inventory
        18: [15, 203], // Inventory
        27: [15, 239], // Inventory
        36: [15, 283], // Tool bar
        45: [153, 123] // Left hand
    }
    // Add armor slots (5 - 8)
    for (let i = 5 + 1; i <= 8; i++) {
        windowSlotsCoords.inventory[i] = [windowSlotsCoords.inventory[i - 1][0], windowSlotsCoords.inventory[i - 1][1] + 36]
    }
    // Add inventory and tool bar slots
    for (let i = 9; i < 5 * 9; i += 9) {
        for (let j = 1; j <= 8; j++) {
            windowSlotsCoords.inventory[i + j] = [windowSlotsCoords.inventory[i][0] + 36 * j, windowSlotsCoords.inventory[i][1]]
        }
    }

    return windowSlotsCoords
}

async function update(window, canvas, windowSlotsCoords, assets) {
    if (!window) return;

    const ctx = canvas.getContext("2d");

    // Draw background
    await new Promise((resolve) => {
        const windowImage = new Image();
        windowImage.addEventListener("load", function () {
            canvas.width = windowImage.width;
            canvas.height = windowImage.height;
            ctx.drawImage(windowImage, 0, 0);

            resolve();
        });
        windowImage.src = `windows/inventory.png`;
    });

    // Draw slots
    for (const slot in window.slots) {
        const item = window.slots[slot]


        if (!item) continue;

        const sbID = item.nbt?.value?.ExtraAttributes?.value?.id?.value

        console.log(sbID, assets[sbID])

        if (!sbID || !assets[sbID]) continue;


        const slotCoordinates =
            windowSlotsCoords['inventory'][slot];

        const slotImage = new Image();
        slotImage.src = "data:image/png;base64," + assets[item.nbt.value.ExtraAttributes.value.id.value]
        slotImage.onload = function () {
            // Draw slot image
            ctx.imageSmoothingEnabled = false;

            if (slotImage.height === 64 && slotImage.width === 64) {
                // this image is split up into a bunch of 8x8 squares, creating a net of the head
                // we can use this to create a 3D model of the head
                // they form a 2x8 grid of 8x8 squares
                // we only need to draw the front, right, and top faces at a 45 degree angle
                // the front face is a 8x8 square at (8, 8)
                // the right face is a 8x8 square at (16, 8)
                // the top face is a 8x8 square at (8, 0)
                // the left face is a 8x8 square at (0, 8)
                // draw front face

                ctx.drawImage(
                    slotImage,
                    8,
                    8,
                    8,
                    8,
                    slotCoordinates[0] + 2,
                    slotCoordinates[1] + 2,
                    28,
                    28
                );
            } else {
                ctx.drawImage(
                    slotImage,
                    slotCoordinates[0],
                    slotCoordinates[1],
                    32,
                    32
                );
            }

            // Draw slot count
            if (item.count > 1) {
                ctx.font = "20px monospace";
                ctx.fillStyle = "black";
                ctx.textAlign = "end";
                ctx.fillText(
                    item.count,
                    slotCoordinates[0] + 33,
                    slotCoordinates[1] + 31
                );
                ctx.fillStyle = "white";
                ctx.fillText(
                    item.count,
                    slotCoordinates[0] + 32,
                    slotCoordinates[1] + 30
                );
            }
        };
    }
}
