const until = document.getElementById('time-box-until')
const timeBoxElapsed = document.getElementById('time-box-elapsed')

let updateSoon = false
function updateTimer (data) {
  if (!updateSoon) {
    until.innerText = `${data} seconds until update`
  }

  socket.once('updateSoon', () => {
    updateSoon = true
    until.innerText = 'Auction updating soon...'
  })
}

function msToTime (seconds) {
  const ms = seconds % 1000
  seconds = (seconds - ms) / 1000
  const secs = seconds % 60
  seconds = (seconds - secs) / 60
  const mins = seconds % 60
  const hrs = (seconds - mins) / 60

  return pad(hrs) + ':' + pad(mins) + ':' + pad(secs)
}

function pad (n, z) {
  z = z || 2
  return ('00' + n).slice(-z)
}

socket.on('auctionUpdate', () => {
  updateSoon = false
})

socket.on('elapsed', (data) => {
  updateTimer(60 - new Date(data).getSeconds())
  timeBoxElapsed.innerText = msToTime(data)
})
